/*
 * MACRO hackery used to define FMS settings in various ways
 * To use this, define "LF_FMS_ONE_SETTING" as desired, then
 * include this file.
 * For example:
 *
 * #define LF_FMS_ONE_SETTING(name, type, dflt, punits, sunits) \
 *   { #name, type, #dflt, #punits, #sunits }
 *
 * or
 *
 * #define LF_FMS_ONE_SETTING(name, type, dflt, punits, sunits) \
 *   int fs_ ## name ##;
 */

/*
 * undefine the master MACRO
 */
#ifdef LF_FMS_ALL_SETTINGS
#undef LF_FMS_ALL_SETTINGS
#undef LF_FMS_ONE_INT_SETTING
#endif

/* a shortcut */
#define LF_FMS_ONE_INT_SETTING(name, dflt, sunits, punits) \
    LF_FMS_ONE_SETTING(name, int, LF_FPT_INTEGER, dflt, sunits, punits)
#define LF_FMS_ONE_STR_SETTING(name, dflt) \
    LF_FMS_ONE_SETTING(name, __charstar, LF_FPT_STRING, dflt, NULL, NULL)

/*
 * Then define using whatever ONE_SETTING has been defined
 */
#define LF_FMS_ALL_SETTINGS \
  LF_FMS_ONE_INT_SETTING(						\
      low_freq_monitor_interval, 120, second, seconds)			\
  LF_FMS_ONE_INT_SETTING(						\
      lf_badcrc_threshold, 5, badcrc, badcrcs)		 		\
  LF_FMS_ONE_INT_SETTING(						\
      lf_fatal_badcrc_threshold, 100, badcrc, badcrcs)	 		\
  LF_FMS_ONE_INT_SETTING(						\
      very_low_freq_monitor_interval, 1800, second, seconds) 		\
  LF_FMS_ONE_INT_SETTING(						\
      vlf_portflip_threshold, 10, transition, transitions) 		\
  LF_FMS_ONE_INT_SETTING(switch_query_interval, 30, second, seconds)	\
  LF_FMS_ONE_INT_SETTING(link_verify_interval, 30, second, seconds)	\
  LF_FMS_ONE_INT_SETTING(link_verify_timeout, 250, ms, ms)		\
  LF_FMS_ONE_INT_SETTING(link_verify_retries, 40, retry, retries)	\
  LF_FMS_ONE_INT_SETTING(nic_scout_timeout, 250, ms, ms)		\
  LF_FMS_ONE_INT_SETTING(nic_scout_retries, 3, retry, retries)		\
  LF_FMS_ONE_INT_SETTING(nic_query_interval, 60, second, seconds)	\
  LF_FMS_ONE_INT_SETTING(map_request_timeout, 90, second, seconds)	\
  LF_FMS_ONE_INT_SETTING(resolve_packet_send_count, 500, packet, packets) \
  LF_FMS_ONE_INT_SETTING(resolve_packet_min, 240, packet, packets)	\
  LF_FMS_ONE_INT_SETTING(resolve_packet_max, 1200, packet, packets)	\
  LF_FMS_ONE_INT_SETTING(resolve_retries, 5, retry, retries)		\
  LF_FMS_ONE_INT_SETTING(						\
      linecard_overtemp_threshold_0, 48, degree C, degrees C)		\
  LF_FMS_ONE_INT_SETTING(						\
      linecard_overtemp_hysteresis_0, 3, degree C, degrees C)		\
  LF_FMS_ONE_INT_SETTING(						\
      linecard_overtemp_threshold_1, 48, degree C, degrees C)		\
  LF_FMS_ONE_INT_SETTING(						\
      linecard_overtemp_hysteresis_1, 3, degree C, degrees C)		\
  LF_FMS_ONE_STR_SETTING(preferred_mapper, )
